﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividualGetAll]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HospitalHealthProviderIndividualGetAll]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Create date:   14/10/2015
-- Description:   Gets the Hospital for Health Provider Individual using Hospital Id
-- 18/02/2016 Updated to filter by HospitalCodeSystem
-- =============================================

CREATE PROCEDURE [hips].[HospitalHealthProviderIndividualGetAll]
(
	@HealthProviderIndividualId INT = NULL,
	@HospitalCodeSystem varchar(256)
)
AS
BEGIN

	SELECT hhpi.HospitalId,
		   hhpi.HealthProviderIndividualId,
		   hhpi.CisProviderIdentifier,
		   hhpi.PasProviderIdentifier,
		   hpi.LocalProviderCode,
		   hc.Code AS [HospitalCode],
		   cs.Code AS [HospitalCodeSystem],
		   hhpi.DateCreated,
		   hhpi.UserCreated,
		   hhpi.DateModified,
		   hhpi.UserModified 
	FROM 
		[hips].[HospitalHealthProviderIndividual] hhpi
	INNER JOIN 
		[hips].[HealthProviderIndividual] hpi ON hhpi.HealthProviderIndividualId = hpi.HealthProviderIndividualId
	INNER JOIN
		[hips].[HospitalCode] hc ON hhpi.HospitalId = hc.HospitalId
	INNER JOIN
		[hips].[CodeSystem] cs ON hc.CodeSystemId = cs.CodeSystemId
		
	WHERE 
		(@HospitalCodeSystem = cs.Code) AND
		(@HealthProviderIndividualId = hhpi.HealthProviderIndividualId OR @HealthProviderIndividualId IS NULL)
END


GO
GRANT EXEC ON [hips].[HospitalHealthProviderIndividualGetAll] TO RunStoredProcedure
GO
